unit Main;

interface

uses WinTypes, WinProcs, SysUtils, Classes, Graphics, Forms, Controls, Menus,
  StdCtrls, Dialogs, Buttons, Messages, ExtCtrls, Mcombbox, MultLang, DTC,
  MDlgs, MMsg, MCtls, MStrLst, MIcons, MImpExp, MObjSize, MAdptOn, MDefStr, MEdit,
  MReg;

type
  TMainForm = class(TForm)
    MainMenu1: TMainMenu;
    Panel1: TPanel;
    StatusLine: TPanel;
    File1: TMenuItem;
    Panel2: TPanel;
    Window1: TMenuItem;
    Help1: TMenuItem;
    FileExitItem: TMenuItem;
    WindowCascadeItem: TMenuItem;
    WindowTileItem: TMenuItem;
    WindowArrangeItem: TMenuItem;
    WindowMinimizeItem: TMenuItem;
    Features1: TMenuItem;
    Language1: TMenuItem;
    DateTimeCurrency1: TMenuItem;
    Commondialogs1: TMenuItem;
    Messagedialogs1: TMenuItem;
    CommonControls1: TMenuItem;
    Stringlists1: TMenuItem;
    Icons1: TMenuItem;
    ImportExport1: TMenuItem;
    Objectresizing1: TMenuItem;
    Userdefinedstrings1: TMenuItem;
    Adopton1: TMenuItem;
    Speedinlargeprojects1: TMenuItem;
    Order1: TMenuItem;
    MultLang1: TMultLang;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure WindowCascadeItemClick(Sender: TObject);
    procedure UpdateMenuItems(Sender: TObject);
    procedure WindowTileItemClick(Sender: TObject);
    procedure WindowArrangeItemClick(Sender: TObject);
    procedure FileExitItemClick(Sender: TObject);
    procedure WindowMinimizeItemClick(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure DateTimeCurrency1Click(Sender: TObject);
    procedure Commondialogs1Click(Sender: TObject);
    procedure Messagedialogs1Click(Sender: TObject);
    procedure CommonControls1Click(Sender: TObject);
    procedure Stringlists1Click(Sender: TObject);
    procedure Icons1Click(Sender: TObject);
    procedure ImportExport1Click(Sender: TObject);
    procedure Objectresizing1Click(Sender: TObject);
    procedure Adopton1Click(Sender: TObject);
    procedure Userdefinedstrings1Click(Sender: TObject);
    procedure Speedinlargeprojects1Click(Sender: TObject);
    procedure Order1Click(Sender: TObject);
    procedure MultLang1Translated(Sender: TObject; LanguageName: String;
      Successful: Boolean);
  private
    { Private declarations }
    FClientInstance,
    FPrevClientProc : TFarProc;
    procedure ClientWndProc(VAR Message: TMessage);
    procedure ShowHint(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.ClientWndProc(var message: TMessage);
var WinDC : hDC; NewRect: TRect;
begin
  with Message do
    case Msg of WM_ERASEBKGND:
      begin
      WinDC := TWMEraseBkGnd(Message).DC;
      NewRect := Rect(0, 0, ClientWidth, ClientHeight);
      Canvas.Handle:=WinDC;
      Canvas.Brush.Color:=clBtnFace;
      Canvas.FillRect(NewRect);
      Canvas.CopyMode:=cmMergeCopy;
      Canvas.TextOut(Label1.Left, Label1.Top, Label1.Caption);
      Canvas.TextOut(Label2.Left, Label2.Top, Label2.Caption);
      Canvas.TextOut(Label3.Left, Label3.Top, Label3.Caption);
      Canvas.TextOut(Label4.Left, Label4.Top, Label4.Caption);
      Canvas.TextOut(Label5.Left, Label5.Top, Label5.Caption);
      Canvas.TextOut(Label6.Left, Label6.Top, Label6.Caption);
      Canvas.TextOut(Label7.Left, Label7.Top, Label7.Caption);
      Canvas.TextOut(Label8.Left, Label8.Top, Label8.Caption);
      Result := 1;
      end
    else
      Result := CallWindowProc(FPrevClientProc, ClientHandle, Msg, wParam, lParam);
    end;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  FClientInstance := MakeObjectInstance(ClientWndProc);
  FPrevClientProc := Pointer(GetWindowLong(ClientHandle, GWL_WNDPROC));
  SetWindowLong(ClientHandle, GWL_WNDPROC, LongInt(FClientInstance));
  Application.OnHint := ShowHint;
  Screen.OnActiveFormChange := UpdateMenuItems;
end;

procedure TMainForm.ShowHint(Sender: TObject);
begin
  StatusLine.Caption := Application.Hint;
end;

procedure TMainForm.FileExitItemClick(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.WindowCascadeItemClick(Sender: TObject);
begin
  Cascade;
end;

procedure TMainForm.WindowTileItemClick(Sender: TObject);
begin
  Tile;
end;

procedure TMainForm.WindowArrangeItemClick(Sender: TObject);
begin
  ArrangeIcons;
end;

procedure TMainForm.WindowMinimizeItemClick(Sender: TObject);
var
  I: Integer;
begin
  { Must be done backwards through the MDIChildren array }
  for I := MDIChildCount - 1 downto 0 do
    MDIChildren[I].WindowState := wsMinimized;
end;

procedure TMainForm.UpdateMenuItems(Sender: TObject);
begin
  WindowCascadeItem.Enabled := MDIChildCount > 0;
  WindowTileItem.Enabled := MDIChildCount > 0;
  WindowArrangeItem.Enabled := MDIChildCount > 0;
  WindowMinimizeItem.Enabled := MDIChildCount > 0;
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Screen.OnActiveFormChange := nil;
end;

procedure TMainForm.DateTimeCurrency1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TDTCDlg') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TDTCDlg.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Commondialogs1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TDlgsDlg') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TDlgsDlg.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Messagedialogs1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TMMsgDlg') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TMMsgDlg.Create(Application);
  AChild.Show;
end;

procedure TMainForm.CommonControls1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TMCtrlsDlg') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TMCtrlsDlg.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Stringlists1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TStrListDlg') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TStrListDlg.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Icons1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TIcons') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TIcons.Create(Application);
  AChild.Show;
end;

procedure TMainForm.ImportExport1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TImpExp') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TImpExp.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Objectresizing1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TObjSize') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TObjSize.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Adopton1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TAdptOn') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TAdptOn.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Userdefinedstrings1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TDefStr') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TDefStr.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Speedinlargeprojects1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TEditor') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TEditor.Create(Application);
  AChild.Show;
end;

procedure TMainForm.Order1Click(Sender: TObject);
var I: Integer; AChild:TForm;
begin
  AChild:=nil;
  for I := 0 to MDIChildCount-1 do
    if (MDIChildren[I].ClassName='TRegister') then AChild:=MDIChildren[I];
  if (AChild=nil) then AChild:=TRegister.Create(Application);
  AChild.Show;
end;

procedure TMainForm.MultLang1Translated(Sender: TObject;
  LanguageName: String; Successful: Boolean);
var oldHeight:Word;
begin
  OldHeight:=Height; Height:=0; Height:=OldHeight;
end;

end.
